import numpy as np

class SeqLinearRegress:
    def __init__(self,inf_bits=5,distractor_bits=0,flip_bit=-1,pow_2=3):
        self.inf_bits=inf_bits
        self.distractor_bits=distractor_bits
        self.target=np.array(0.0)
        self.pow_2=pow_2
        self.weights=np.random.choice([-1,1],size=(self.pow_2+1,inf_bits,))
        self.inputs=np.zeros((2**self.pow_2+1,inf_bits))
        self.counter=0
        self.flip_bit=flip_bit
    
    def _flip_bit(self):
        index=np.random.randint(0,self.inf_bits,size=1)[0]
        if self.weights[index]==1:
            self.weights[index]=-1
        else:
            self.weights[index]=1

    def observe(self):
        if self.flip_bit>0 and (self.counter+1)%self.flip_bit==0:
            self.counter=0
            self._flip_bit()
        obs=np.random.normal(0.0,1.0,size=(self.inf_bits+self.distractor_bits))
        self.inputs=np.concatenate([self.inputs[1:],obs[0:self.inf_bits].reshape(1,-1)])
        indexes=-2**np.arange(0,self.pow_2+1)
        self.target=np.dot(self.inputs[indexes].reshape(-1),self.weights.reshape(-1)) #/self.history
        self.counter+=1
        return obs,self.target.copy()


